import excel "${pathgeo}/Table d'appartenance géographique des communes (TAGC)/table_passage_geo2003_geo2020", clear
keep A B
drop if _n <= 6
ren A depcom
ren B depcom_new
tempfile depcom_new
save "${tmp}/depcom_new", replace

import excel "${pathgeo}/Zones d'Emploi (ZE)\2010\ZE2010 au 01-01-2020", clear first sheet("Composition_communale")
keep if _n > 5
ren Zonesdemploi2010 depcom_new
gduplicates drop depcom_new, force
merge 1:m depcom_new using "${tmp}/depcom_new.dta", nogen keep(2 3)
ren B libcom
ren C ZE2010
ren E departement
ren F region
replace departement  = "20" if inlist(departement,"2A","2B")
destring departement region, replace
keep depcom libcom ZE2010 departement region

global N =_N

gen expvar = 1
replace expvar = expvar + 20 if depcom=="75056"
replace expvar = expvar + 13216-13201+1 if depcom=="13055"
replace expvar = expvar + 69389-69381+1 if depcom=="69123"

expand expvar

destring depcom, replace force

replace depcom = 13201 + _n - 1 -$N if libcom == "Marseille" & _n>$N

replace depcom = 69381 + _n - 1 -$N - 16 if libcom == "Lyon" & _n>$N 

replace depcom = 75101 + _n - 1 -$N - 16 - 9 if libcom == "Paris" & _n>$N 

drop expvar
drop if mi(depcom) | depcom >= 97000

save "${data}/Utils/depcom_ZE_mapping", replace



import excel "${pathgeo}/Zones d'Emploi (ZE)\2010\ZE2010 au 01-01-2020", clear first sheet("Composition_communale")
keep if _n > 5
ren Zonesdemploi2010 depcom_new
gduplicates drop depcom_new, force
ren B libcom
ren C ZE2010
ren F reg
keep ZE2010 reg

gen IDF = (reg == "11")

gcollapse (max) IDF, by(ZE2010)

destring ZE2010, replace

save "${data}/Utils/ZE_regIDF_mapping", replace